"""
SHAC (Spherical Harmonic Audio Codec) Module

This module provides spatial audio processing capabilities using spherical harmonics
for the Atabey Symphony project. It has been directly integrated to eliminate
external dependencies and provide a seamless experience.

Main components:
- SHACCodec: The main codec class for encoding, processing, and rendering spatial audio
- File I/O: Support for the .shac file format that preserves full spatial information
- Binaural rendering: Convert 3D spatial audio to headphone-compatible stereo
- Math utilities: Core mathematical functions for spherical harmonic processing
"""

from .codec import (
    SHACCodec, 
    SHACFileWriter, 
    SHACFileReader,
    AmbisonicNormalization,
    AmbisonicOrdering,
    HRTFInterpolationMethod,
    DirectivityPattern,
    SourceAttributes,
    RoomAttributes,
    BinauralRendererConfig
)

__version__ = '1.0.0'