"""
Core Package - Audio processing and project management

Contains the core functionality for spatial audio processing,
project management, and real-time audio engine for the desktop application.
"""

# Desktop application components  
from .audio_engine import AudioEngine, AudioSource
from .project_manager import ProjectManager, SHACProject
from .spatial_processor import SpatialProcessor

# Legacy modules (for integration)
from . import sound_engine          # High-level sound engine for composition
from . import shac_export          # Direct SHAC file creation

__all__ = [
    'AudioEngine',
    'AudioSource', 
    'ProjectManager',
    'SHACProject',
    'SpatialProcessor',
    'sound_engine',
    'shac_export'
]